<?php
header('Content-Type: application/json');
require_once 'config.php';
session_start();

$action = $_POST['action'] ?? '';

switch ($action) {

    case 'register':
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);

        $check = $conn->prepare("SELECT * FROM users WHERE username=?");
        $check->bind_param("s", $username);
        $check->execute();
        $res = $check->get_result();

        if ($res->num_rows > 0) {
            echo json_encode(['success' => false, 'message' => 'Nom déjà utilisé']);
            exit;
        }

        $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->bind_param("ss", $username, $password);
        $stmt->execute();

        $_SESSION['username'] = $username;
        echo json_encode(['success' => true, 'message' => 'Compte créé']);
        break;


    case 'login':
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);

        $stmt = $conn->prepare("SELECT * FROM users WHERE username=? AND password=?");
        $stmt->bind_param("ss", $username, $password);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res->num_rows == 0) {
            echo json_encode(['success' => false, 'message' => 'Identifiants invalides']);
            exit;
        }

        $_SESSION['username'] = $username;
        echo json_encode(['success' => true, 'message' => 'Connecté']);
        break;


    case 'logout':
        if (isset($_SESSION['username'])) {
            require_once 'config.php';
            $u = $_SESSION['username'];
            $stmt = $conn->prepare("SELECT player1, player2, status FROM games WHERE id=1");
            $stmt->execute();
            $g = $stmt->get_result()->fetch_assoc();
            if ($g && $g['status'] !== 'finished' && ($g['player1']===$u || $g['player2']===$u)) {
                $opponent = ($g['player1']===$u) ? $g['player2'] : $g['player1'];
                if (!empty($opponent)) {
                    $up = $conn->prepare("UPDATE games SET status='finished', winner=?, end_reason='abandon' WHERE id=1");
                    $up->bind_param("s", $opponent);
                    $up->execute();
                } else {
                    $conn->query("UPDATE games SET player1=NULL, player2=NULL, status='waiting', winner=NULL, end_reason=NULL WHERE id=1");
                }
            }
        }
        session_destroy();
        echo json_encode(['success'=>true,'message'=>'Déconnecté']);
        break;


    case 'status':
        if (isset($_SESSION['username'])) {
            echo json_encode(['logged_in' => true, 'username' => $_SESSION['username']]);
        } else {
            echo json_encode(['logged_in' => false]);
        }
        break;

    default:
        echo json_encode(['success' => false, 'message' => 'Action inconnue']);
        break;
}
?>
