<?php
require "config.php";
header("Content-Type: application/json");

if (!isset($_SESSION["user_id"])) {
    echo json_encode(["redirect" => false]);
    exit;
}

$user_id = $_SESSION["user_id"];

// Vérifier si l'utilisateur est dans une équipe
$stmt = $pdo->prepare("SELECT team FROM team_queue WHERE user_id = ?");
$stmt->execute([$user_id]);
$userTeam = $stmt->fetchColumn();

// Vérifier si la partie est complète
$checkFull = $pdo->prepare("SELECT COUNT(*) as total FROM team_queue");
$checkFull->execute();
$totalPlayers = $checkFull->fetchColumn();

// Vérifier si une partie est en cours
$gameStmt = $pdo->prepare("SELECT winner FROM game WHERE id = 1");
$gameStmt->execute();
$gameData = $gameStmt->fetch(PDO::FETCH_ASSOC);

// Rediriger seulement si partie complète ET partie en cours (winner = 0)
if ($userTeam && $totalPlayers == 2 && $gameData && $gameData['winner'] == 0) {
    // Partie en cours, rediriger vers la bonne page
    if ($userTeam === "bleu") {
        echo json_encode(["redirect" => true, "url" => "layout_joueur1.html"]);
    } else {
        echo json_encode(["redirect" => true, "url" => "layout_joueur2.html"]);
    }
} else {
    echo json_encode(["redirect" => false]);
}
?>